/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.core;

import java.util.Set;
import net.mehvahdjukaar.moonlight.api.client.model.ExtraModelData;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidColors;
import net.mehvahdjukaar.moonlight.api.map.client.MapDecorationClientManager;
import net.mehvahdjukaar.moonlight.api.platform.ClientHelper;
import net.mehvahdjukaar.moonlight.api.resources.ResType;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynClientResourcesGenerator;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynamicResourcePack;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynamicTexturePack;
import net.mehvahdjukaar.moonlight.core.ClientConfigs;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.mehvahdjukaar.moonlight.core.client.MLRenderTypes;
import net.minecraft.class_2561;
import net.minecraft.class_290;
import net.minecraft.class_2960;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_3264;
import net.minecraft.class_3300;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.ApiStatus;
import org.joml.Vector3f;

@ApiStatus.Internal
public class MoonlightClient {
    private static final ThreadLocal<Boolean> MAP_MIPMAP = ThreadLocal.withInitial(() -> false);
    private static MergedDynamicTexturePack mergedDynamicPack;
    private static ClientConfigs.ShadeFix fixShade;
    private static Vector3f oldL0;
    private static Vector3f oldL1;
    private static Vector3f oldL0n;
    private static Vector3f oldL1n;
    private static final Vector3f NEW_L_0;
    private static final Vector3f NEW_L_1;

    public static void initClient() {
        ClientHelper.addShaderRegistration(MoonlightClient::registerShaders);
        ClientHelper.addClientReloadListener(SoftFluidColors::new, Moonlight.res("soft_fluids"));
        ClientHelper.addClientReloadListener(MapDecorationClientManager::new, Moonlight.res("map_markers"));
        ClientConfigs.init();
        Gen gen = new Gen();
        gen.register();
    }

    public static DynamicTexturePack maybeMergePack(DynamicTexturePack pack) {
        if (!ClientConfigs.MERGE_PACKS.get().booleanValue()) {
            return pack;
        }
        if (mergedDynamicPack == null) {
            mergedDynamicPack = new MergedDynamicTexturePack(){};
        }
        Set<String> nameSpaces = pack.method_14406(pack.getPackType());
        for (String n : nameSpaces) {
            mergedDynamicPack.addNamespaces(n);
        }
        ++MoonlightClient.mergedDynamicPack.mods;
        return mergedDynamicPack;
    }

    public static boolean isClientThread() {
        return class_310.method_1551().method_18854();
    }

    public static void setupClient() {
        ExtraModelData e = ExtraModelData.EMPTY;
    }

    public static void registerShaders(ClientHelper.ShaderEvent event) {
        event.register(Moonlight.res("particle_translucent"), class_290.field_1585, MLRenderTypes.PARTICLE_TRANSLUCENT_SHADER::assign);
        event.register(Moonlight.res("text_alpha_color"), class_290.field_20888, MLRenderTypes.TEXT_COLOR_SHADER::assign);
    }

    public static void afterTextureReload() {
        DynamicResourcePack.clearAfterReload(class_3264.field_14188);
    }

    public static void setMipMap(boolean b) {
        if (ClientConfigs.MAPS_MIPMAP.get() == 0) {
            b = false;
        }
        MAP_MIPMAP.set(b);
    }

    public static boolean isMapMipMap() {
        return MAP_MIPMAP.get();
    }

    public static void beforeRenderGui() {
        if (fixShade == ClientConfigs.ShadeFix.NO_GUI) {
            MoonlightClient.revertFixedShade();
        }
    }

    public static void afterRenderGui() {
        if (fixShade == ClientConfigs.ShadeFix.NO_GUI) {
            MoonlightClient.applyFixedShade();
        }
    }

    private static void revertFixedShade() {
        if (oldL0 != null) {
            class_308.field_24426 = oldL0;
            class_308.field_24427 = oldL1;
            class_308.field_24428 = oldL0n;
            class_308.field_24429 = oldL1n;
            oldL0 = null;
            oldL1 = null;
            oldL0n = null;
            oldL1n = null;
        }
    }

    private static void applyFixedShade() {
        if (oldL0 == null) {
            oldL0 = class_308.field_24426;
            oldL1 = class_308.field_24427;
            oldL0n = class_308.field_24428;
            oldL1n = class_308.field_24429;
        }
        class_308.field_24426 = NEW_L_0;
        class_308.field_24427 = NEW_L_1;
        class_308.field_24428 = NEW_L_0;
        class_308.field_24429 = NEW_L_1;
    }

    static {
        fixShade = ClientConfigs.ShadeFix.FALSE;
        oldL0 = null;
        oldL1 = null;
        oldL0n = null;
        oldL1n = null;
        NEW_L_0 = new Vector3f(0.2f, 0.7777778f, -0.6f).normalize();
        NEW_L_1 = new Vector3f(-0.2f, 0.7777778f, 0.6f).normalize();
    }

    private static class Gen
    extends DynClientResourcesGenerator {
        public Gen() {
            super(new DynamicTexturePack(Moonlight.res("generated_pack")));
            ((DynamicTexturePack)this.dynamicPack).addNamespaces("minecraft");
        }

        @Override
        public Logger getLogger() {
            return Moonlight.LOGGER;
        }

        @Override
        public boolean dependsOnLoadedPacks() {
            return true;
        }

        @Override
        public void regenerateDynamicAssets(class_3300 manager) {
            fixShade = ClientConfigs.FIX_SHADE.get();
            MoonlightClient.revertFixedShade();
            if (fixShade != ClientConfigs.ShadeFix.FALSE) {
                MoonlightClient.applyFixedShade();
                ((DynamicTexturePack)this.dynamicPack).addBytes(new class_2960("shaders/include/light.glsl"), "#version 150\n\n#define MINECRAFT_LIGHT_POWER   (0.6)\n#define MINECRAFT_LIGHT_POWER_FIXED   (0.5)\n#define MINECRAFT_AMBIENT_LIGHT (0.4)\n#define MINECRAFT_AMBIENT_LIGHT_FIXED (0.5)\n\nvec4 minecraft_mix_light(vec3 lightDir0, vec3 lightDir1, vec3 normal, vec4 color) {\n    lightDir0 = normalize(lightDir0);\n    lightDir1 = normalize(lightDir1);\n    float light0 = max(0.0, dot(lightDir0, normal));\n    float light1 = max(0.0, dot(lightDir1, normal));\n\n    float dotP = dot(lightDir0, lightDir1);\n    bool isFixed = dotP > 0.20 && dotP < 0.205;\n    float lightPow = isFixed ? MINECRAFT_LIGHT_POWER_FIXED : MINECRAFT_LIGHT_POWER;\n    float ambientLight = isFixed ? MINECRAFT_AMBIENT_LIGHT_FIXED : MINECRAFT_AMBIENT_LIGHT;\n\n    float lightAccum = min(1.0, (light0 + light1) * lightPow + ambientLight);\n    return vec4(color.rgb * lightAccum, color.a);\n}\n\nvec4 minecraft_sample_lightmap(sampler2D lightMap, ivec2 uv) {\n    return texture(lightMap, clamp(uv / 256.0, vec2(0.5 / 16.0), vec2(15.5 / 16.0)));\n}".getBytes(), ResType.GENERIC);
            }
        }
    }

    private static class MergedDynamicTexturePack
    extends DynamicTexturePack {
        int mods = 0;

        public MergedDynamicTexturePack() {
            super(Moonlight.res("mods_dynamic_assets"));
        }

        @Override
        public class_2561 makeDescription() {
            return class_2561.method_43470((String)("Dynamic resources for " + this.mods + (this.mods == 1 ? " mod" : " mods")));
        }
    }
}

